Option Base 1
Option Explicit

Sub Unique_Characters()
'
' Macro to list only the used characters in a document
' By default the font is ignored, but (part of) a fontname can be entered
'
' Works at least on Word 2010 and Word 2007
'
' Version 1.1 - 14-03-2012
' Created by Toxaris
'
' Small change. Sometimes being too smart bites you back...
' The key of collections is case insensitive, causing missing letters in the result.
' Non-printable characters are also ignored now.
'

Dim let_col As Collection
Dim wordapp As Word.Application
Dim doc As Object
Dim fontname, Result As String
Dim a As Variant
Dim i As Integer


' Enter (part of) fontname. Wildcards will surround the input
fontname = InputBox("Enter (part of) the fontname for which you want the characters", "(part of) fontname")
If fontname = "" Then fontname = "*" Else fontname = "*" + fontname + "*"

' Create a collection to store all unique characters in. Index is used, so when a character is added which
' is already there, an error will raised. This will be skipped. This is a lot faster then looping through
' the collection for each character
Set let_col = New Collection
On Error Resume Next

' Loop through each character in a document and add it to a collection.
For Each a In ActiveDocument.Characters
   If a.Font.Name Like fontname And AscW(a) > 31 Then let_col.Add a, Str(AscW(a))
Next

' Convert the collection into an array.
ReDim word_array(1 To let_col.Count)
For i = 1 To let_col.Count
   word_array(i) = let_col(i)
Next i

' Sort the array.
QuickSort word_array, 1, let_col.Count

' Generate the result string.
Result = ""
  For i = 1 To let_col.Count
      Result = Result & word_array(i)
  Next i

'create new document and place the unique characters in them
Set wordapp = GetObject(, "word.application")
Set doc = wordapp.Documents.Add
wordapp.Selection.Font.Bold = True
wordapp.Selection.TypeText "Searched for fontname:" & fontname
wordapp.Selection.Font.Bold = False
wordapp.Selection.TypeParagraph
wordapp.Selection.TypeText Result
wordapp.Selection.TypeParagraph
Set wordapp = CreateObject("word.application")

End Sub

Public Sub QuickSort(vArray As Variant, inLow As Long, inHi As Long)
' Generic QuickSort. Nicked from a site because I did not want to program it myself

Dim pivot   As Variant
Dim tmpSwap As Variant
Dim tmpLow  As Long
Dim tmpHi   As Long

tmpLow = inLow
tmpHi = inHi

pivot = vArray((inLow + inHi) \ 2)

While (tmpLow <= tmpHi)
   While (vArray(tmpLow) < pivot And tmpLow < inHi)
      tmpLow = tmpLow + 1
   Wend

   While (pivot < vArray(tmpHi) And tmpHi > inLow)
      tmpHi = tmpHi - 1
   Wend

   If (tmpLow <= tmpHi) Then
      tmpSwap = vArray(tmpLow)
      vArray(tmpLow) = vArray(tmpHi)
      vArray(tmpHi) = tmpSwap
      tmpLow = tmpLow + 1
      tmpHi = tmpHi - 1
   End If
Wend

If (inLow < tmpHi) Then QuickSort vArray, inLow, tmpHi
If (tmpLow < inHi) Then QuickSort vArray, tmpLow, inHi

End Sub
